{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "rtd-api.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{- define "dynamicPartnerName" -}}
  {{- $namespace := .Release.Namespace -}}
  {{- $nameParts := splitList "-" $namespace -}}
  {{- if eq (len $nameParts) 2 -}}
    {{- $partnerName := index $nameParts 0 -}}
    {{- $integrationSuffix := index $nameParts 1 -}}
    {{- if ne $integrationSuffix "integration" -}}
      {{- fail "Namespace must end with '-integration'." -}}
    {{- end -}}
    {{- if gt (len $partnerName) 41 -}}
      {{- fail (printf "Partner name is too long, it exceeds 41 characters: %s" $partnerName) -}}
    {{- end -}}
    {{- $partnerName -}}
  {{- else -}}
    {{- if .Values.name -}}
      {{- .Values.name -}}
    {{- else -}}
      {{- fail "Namespace must have exactly two parts: <partner_name> followed by '-integration'." -}}
    {{- end -}}
  {{- end -}}
{{- end -}}
